#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../common/common'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/landing_notifications'

describe '[Story# VAR-9964: Location Booking - Display PACT]'  do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    @landing_appointments = LandingAppointments.new(@driver)
    @modal = Modal.new(@driver)
    TITLE = "Appointments/Requests"
    @db = connectToMongoDB('var-utility')
    restoreCollection('directBookingEligibilityCriteria', 'var-utility', 'bostonDirectScheduling.json', @db)
    restoreCollection('requestEligibilityCriteria', 'var-utility', 'bostonRequestEligibility.json', @db)
    @common.loginEndsOnHome(pw_redacted)
    @common.selectAddAppointmentButton("VA")
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-10180|TC#VAR-10179: Location Booking - Display PACT' do

    it 'should display the PACT team' do
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      @new_appointment.selectState("523")
      @new_appointment.single_facility_pact_element.when_present(TIME_OUT_LIMIT)

      #Displays the PACT Team info
      expected_content =[\
                        "Providers:",
                        "Creamer, Kent",
                        "Your Care Team (PACT)"
      ]

      actual_content = @new_appointment.single_facility_pact_element.text.split("\n")

      compareContents( expected_content, actual_content)
    end

    it 'Verify Details for Pact Team' do

      #Displays the Care Team
      @new_appointment.view_pact_team_element.when_present(TIME_OUT_LIMIT)
      @new_appointment.view_pact_team_element.click
      @modal.modalTitle_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle_element.text).to eq "PACT Members"
      expected_content =[\
                        "Primary Care Providers:",
                        "Creamer, Kent",
                        "Team List:",
                        "Gomez, Shane; McCormack, Asia; Parker, Corinna; Perry, Mary; Tate, Vickie"
      ]

      actual_content = @modal.content_element.text.split("\n")

      compareContents( expected_content, actual_content)

    end

    it 'Verify Pact Team for Multi Facility' do
      @modal.buttons_elements[0].click
      restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
      restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
      @new_appointment.cancelForm
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      @new_appointment.selectState("523")
      @new_appointment.selectLocation("523")
      @new_appointment.pact_team_element.when_present(TIME_OUT_LIMIT)

      #Displays the PACT Team info
      expected_content =[\
                        "Providers:",
                        "Creamer, Kent",
                        "Your Care Team (PACT)"
      ]

      actual_content = @new_appointment.pact_team_element.text.split("\n")

      compareContents( expected_content, actual_content)

    end

    it 'Verify Details of Pact Team' do

      @new_appointment.view_pact_team_element.when_present(TIME_OUT_LIMIT)
      @new_appointment.view_pact_team_element.click
      @modal.modalTitle_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle_element.text).to eq "PACT Members"
      expected_content =[\
                        "Primary Care Providers:",
                        "Creamer, Kent",
                        "Team List:",
                        "Gomez, Shane; McCormack, Asia; Parker, Corinna; Perry, Mary; Tate, Vickie"
      ]

      actual_content = @modal.content_element.text.split("\n")

      compareContents( expected_content, actual_content)
      @modal.buttons_elements[0].click
    end

  end

end